/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process;

import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWProcessMenuHelper;
import filenet.vw.toolkit.design.canvas.process.VWProcessMenuItem;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;

class VWProcessCollectionMenu
extends JMenu
implements ActionListener {
    private static final int GROUP_SIZE = 45;
    private VWProcessMenuHelper m_processMenuHelper = null;
    private Vector m_processMenuList = null;

    public VWProcessCollectionMenu(VWProcessMenuHelper processMenuHelper) {
        super(VWResource.s_menuWorkflows_withHK);
        this.m_processMenuHelper = processMenuHelper;
        this.reinitialize();
    }

    public void setText(String text) {
        JMenu tempMenu = VWStringUtils.getMenuUsingString(text);
        if (tempMenu != null) {
            super.setText(tempMenu.getText());
            this.setMnemonic(tempMenu.getMnemonic());
        } else {
            super.setText(text);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource() instanceof VWProcessMenuItem) {
                VWProcessMenuItem menuItem = (VWProcessMenuItem)event.getSource();
                this.m_processMenuHelper.editProcess(menuItem.getAuthPropertyData());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            this.removeAll();
            this.m_processMenuList = new Vector();
            int nCount = 0;
            int nSubMenuIndex = 1;
            JMenu subMenu = this;
            VWAuthPropertyData[] dataItems = this.m_processMenuHelper.getProcessDataItems();
            if (dataItems != null) {
                if (dataItems.length > 45) {
                    subMenu = new JMenu(VWResource.s_processSubMenu.toString(Integer.toString(nSubMenuIndex)));
                    this.add(subMenu);
                }
                for (int nIndex = 0; nIndex < dataItems.length; ++nIndex) {
                    ImageIcon menuIcon = VWProcessMenuItem.ICON_PROCESS;
                    if (this.m_processMenuHelper.isMainProcessName(dataItems[nIndex].getWorkflowDefinition().getName())) {
                        menuIcon = VWProcessMenuItem.ICON_MAIN_PROCESS;
                    }
                    VWProcessMenuItem menuItem = new VWProcessMenuItem(dataItems[nIndex], (Icon)menuIcon);
                    menuItem.addActionListener(this);
                    this.m_processMenuList.addElement(menuItem);
                    if (nCount++ > 45) {
                        subMenu = new JMenu(VWResource.s_processSubMenu.toString(Integer.toString(++nSubMenuIndex)));
                        this.add(subMenu);
                        nCount = 0;
                    }
                    subMenu.add(menuItem);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWProcessMenuItem findProcessMenuItem(String wflName) {
        try {
            for (int nIndex = 0; nIndex < this.m_processMenuList.size(); ++nIndex) {
                VWProcessMenuItem processMenuItem = (VWProcessMenuItem)this.m_processMenuList.elementAt(nIndex);
                VWWorkflowDefinition tmpWflDef = processMenuItem.getAuthPropertyData().getWorkflowDefinition();
                if (VWStringUtils.compare(wflName, tmpWflDef.getName()) != 0) continue;
                return processMenuItem;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

